/* ********************************************************************
  ˼Ѹרϵͳ V6 ƷתרҵʽSQL

  By Sam on 2009-01-07
**********************************************************************/

/* ѯƷϢ */
select Barcode = g.item_subno,
       GoodsNO = g.item_no,
       GoodsName = g.item_subname,
       CategoryName = c.item_clsname,
       Spec = item_size,
       Unit = g.unit_no,
       BuyPrice = price,
       SalePrice = sale_price,
       BuyTaxRate = purchase_tax * 100,
       SaleTaxRate = sale_tax * 100,
       CaseUnits = purchase_spec,
       Home = product_area,
       VendorNO = g.main_supcust,
       VendorName = convert(varchar(60), ''),
       BrandNO = g.item_brand,
       Brand = convert(varchar(40), ''),
       StockQty = convert(numeric(12,3), null)
  into #a
  from t_bd_item_info g, t_bd_item_cls c
  where g.item_clsno = c.item_clsno

/* ¹Ӧ */
update #a
  set VendorName = case when VendorNO = '0' then '' else v.sup_name end
  from t_bd_supcust_info v
  where VendorNO = v.supcust_no

/* Ʒ */
update #a
set Brand = case when v.code_name = 'Ʒ' then '' else v.code_name end
  from t_bd_base_code v
  where BrandNO = v.code_id and v.type_no = 'PP'

/* вֿĿ */
select item_no, stock_qty = sum(stock_qty) into #b
  from t_im_branch_stock
  group by item_no

update #a
  set StockQty = b.stock_qty
  from #b b
  where GoodsNO = b.item_no

update #a set Barcode = (select min(item_barcode) from t_bd_item_barcode b where GoodsNO = b.item_no)
  where #a.Barcode = '0'

select
     = CategoryName,
    Ʒ = GoodsName,
     = isnull(Spec, ''),
    λ = isnull(Unit, ''),
     = Barcode,
     = BuyPrice,
    ۼ = SalePrice,
     = StockQty,
    Ӧ = isnull(VendorName, ''),
    ˰ = BuyTaxRate,
    ˰ = SaleTaxRate,
    װλ = CaseUnits,
     = isnull(Home, ''),
    Ʒ = isnull(Brand, ''),
    Ʒ = GoodsNO into #c
  from #a
union
select
     = CategoryName,
    Ʒ = GoodsName,
     = isnull(Spec, ''),
    λ = isnull(Unit, ''),
     = b.item_barcode,
     = BuyPrice,
    ۼ = SalePrice,
     = 0,
    Ӧ = isnull(VendorName, ''),
    ˰ = BuyTaxRate,
    ˰ = SaleTaxRate,
    װλ = CaseUnits,
     = isnull(Home, ''),
    Ʒ = isnull(Brand, ''),
    Ʒ = GoodsNO
  from #a a, t_bd_item_barcode b
  where GoodsNO = b.item_no
    and b.item_barcode not in (select Barcode from #a c where c.GoodsNO = a.GoodsNO)

select * from #c order by Ʒ, abs() desc

drop table #a, #b, #c


